*********************************************************
* This program uses output from Rage-Rgequate to create *
*   graphs like those in Figure 3.6 on page 91 of Kolen *
*   and Brennan (the example data is from the example   *
*   file input.dat).  This program will work with any   *
*   set of S values.  You must indicate the number of S *
*   levels you used and specify the specific S values.  *
*   Paste in your output where indicated.               *
*                                     -Brett Foley      *
*********************************************************;
*********************************************************
* Minor changes have been made from Brett's orignal SAS *
*   codes such that the final codes could be generated  *
*   by Rage-Rgequate automatically.                     *
*                                     -Zhongmin Cui     *
*********************************************************;

*------------------------------------* 
| Enter the number of S levels here. |
*------------------------------------*;
%LET numlevels = 
;

*------------------------------------*
| Enter the S values here (separated |
|   by spaces).                      |
*------------------------------------*;
%LET levels = 
;


*-----------------------------------------------------*
| Paste Raw-to-Raw Score Conversion for Postsmoothing |
|   output here. (after "datalines" command)          |
*-----------------------------------------------------*;
data postplots;
input XScore SE  NoSmooth s1-s&numlevels linear; 
datalines;
;
run;


*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*
!        Do not alter code below this point!      !
*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*;



*This reformats the data (tall format);
data postplots_reformatted; set postplots;

array testarray1 [&numlevels] s1-s&numlevels;
array testarray2 [&numlevels] sx1-sx&numlevels;
array x1[&numlevels] y1-y&numlevels (&levels);

do i = 1 to &numlevels;
    testarray2[i] = testarray1[i]-xscore;
end;

NoSmoothe= NoSmooth - XScore;
lineare= linear-XScore;
SElow = (NoSmooth - SE) - XScore;
SEhi  = (NoSmooth + SE) - XScore;

do i = 1 to &numlevels;
slevel=i; eqdiff=testarray2[i]; S_Value = x1[i]; output;
end;
keep xscore slevel eqdiff NoSmoothe SEhi SElow S_Value;
run;


*This deletes the contents of the default graphics catalog work.gseg;
proc greplay nofs igout=work.gseg; delete _all_; run; quit;

*This creates axis labels;
axis1 label = (font=swiss height=1 'Raw Score Form X');
axis2 label = (angle=90 font=swiss height=1 'Form Y Equivalent Minus Form X Score');

*This sets up legends for the graphs;
legend1 label=none
        shape=symbol(7,1)
        position=(top center inside)
		value=('Smoothed' 'Unsmoothed' '+1 S.E.' '-1 S.E.')
        mode=share;


*******************************************
* This prints 1 graph per page (looks best*
*   printed in landscape format)          *
*******************************************;
proc sort; by S_Value; run;

options nobyline;
proc gplot data=postplots_reformatted;
   by S_Value;
   plot eqdiff*xscore NoSmoothe*xscore SEhi*xscore SElow*xscore
        /overlay haxis=axis1 vaxis=axis2 VREF = 0 legend=legend1;
        symbol1 color=red   i=line v=dot h=1;
		symbol2 color=black i=line v=triangle h=1;
		symbol3 color=blue i=line line=3 h=1;
		symbol4 color=green i=line line=3 h=1;
        title 'Raw-to-raw equivalents for postsmoothing, S = #byval(S_Value)';
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (4 graphs per page), print in    *
*  landscape format.                      *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup4graphs;
    %if (&numlevels LE 4) %then %do;
        treplay 1:Gplot  2:Gplot1 3:Gplot2 4:Gplot3; 
    %end;
    %else %if (&numlevels LE 8) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2 4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6 4:Gplot7;
	%end;
	%else %if (&numlevels LE 12) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6  4:Gplot7;
        treplay 1:Gplot8  2:Gplot9 3:Gplot10 4:Gplot11;
    %end;
	%else %if (&numlevels LE 16) %then %do;
        treplay 1:Gplot    2:Gplot1  3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4   2:Gplot5  3:Gplot6  4:Gplot7;
		treplay 1:Gplot8   2:Gplot9  3:Gplot10 4:Gplot11;
		treplay 1:Gplot12  2:Gplot13 3:Gplot14 4:Gplot15;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp1 des='Four per page'
   1/llx=0 lly=51
     ulx=0 uly=100
     urx=49 ury=100
     lrx=49 lry=51
     color=white
   2/llx=51 lly=51
     ulx=51 uly=100
     urx=100 ury=100
     lrx=100 lry=51
     color=white
   3/llx=0 lly=0
     ulx=0 uly=49
     urx=49 ury=49
     lrx=49 lry=0
     color=white
   4/llx=51 lly=0
     ulx=51 uly=49
     urx=100 ury=49
     lrx=100 lry=0
     color=white;

   template= newtemp1;

   %setup4graphs;
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (8 graphs per page), print in    *
*  portrait format.                       *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup8graphs;
    %if (&numlevels LE 8) %then %do;
        treplay 1:Template  2:Templat1;
	%end;
    %else %if (&numlevels LE 12) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2;
	%end;
	%else %if (&numlevels LE 16) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2  2:Templat3;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp2 des='Two per page'
   1/llx=0 lly=50.5
     ulx=0 uly=100
     urx=100 ury=100
     lrx=100 lry=50.5
     color=white
   2/llx=0 lly=0
     ulx=0 uly=49.5
     urx=100 ury=49.5
     lrx=100 lry=0
     color=white;

   template = newtemp2;

   %setup8graphs;
run; quit;




